/*-------------------------------------------------------------------------
 *
 * encryption.h
 *	  Client code to support full cluster encryption.
 *
 * Portions Copyright (c) 2019-2022, CYBERTEC PostgreSQL International GmbH
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/include/fe_utils/encryption.h
 *
 *-------------------------------------------------------------------------
 */
#include "common/encryption.h"

extern void init_kdf(int key_len);
extern void update_kdf_key_length(uint8 key_len);
extern void write_kdf_file(char *dir);
extern int read_kdf_file(char *dir, bool missing_ok);
extern void derive_key_from_password(unsigned char *encryption_key,
									 const char *password, int len);

