/*-------------------------------------------------------------------------
 *
 * nodeWindowAgg.h
 *	  prototypes for nodeWindowAgg.c
 *
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/executor/nodeWindowAgg.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef NODEWINDOWAGG_H
#define NODEWINDOWAGG_H

#include "access/parallel.h"
#include "nodes/execnodes.h"

extern WindowAggState *ExecInitWindowAgg(WindowAgg *node, EState *estate, int eflags);
extern void ExecEndWindowAgg(WindowAggState *node);
extern void ExecReScanWindowAgg(WindowAggState *node);
/* TODO Consider moving 'Redistribute' to separate file. */
extern RedistributeState *ExecInitRedistribute(Redistribute *node,
													 EState *estate,
													 int eflags);
extern void ExecEndRedistribute(RedistributeState *node);
extern void ExecReScanRedistribute(RedistributeState *node);
extern void ExecRedistributeEstimate(RedistributeState *node,
									 ParallelContext *pcxt);
extern void ExecRedistributeInitializeDSM(RedistributeState *node,
										  ParallelContext *pcxt);
extern void ExecRedistributeReInitializeDSM(RedistributeState *state,
											ParallelContext *cxt);
extern void ExecRedistributeInitializeWorker(RedistributeState *state,
											 ParallelWorkerContext *pcxt);
extern void ExecRedistributeRetrieveInstrumentation(RedistributeState *node);
extern void ExecShutdownRedistribute(RedistributeState *node);
#endif							/* NODEWINDOWAGG_H */
